from fastapi import APIRouter, Depends
from app.db import database
from app.v1.models.platform.geofences import (
    GeofenceCreate, Geofence, GeofenceUpdate, GeofencesList
)
from app.v1.services.platform.geofences import (
    create_geofence_service, get_geofence_service,
    update_geofence_service, delete_geofence_service,
    list_geofences_service
)

router = APIRouter()

@router.post("/", response_model=Geofence)
async def create_geofence(geofence: GeofenceCreate, db=Depends(database.get_mongo_db)):
    return await create_geofence_service(geofence, db)

@router.get("/", response_model=GeofencesList)
async def list_geofences(skip: int = 0, limit: int = 10, db=Depends(database.get_mongo_db)):
    return await list_geofences_service(skip, limit, db)

@router.get("/{account_id}", response_model=Geofence)
async def get_geofence(account_id: str, db=Depends(database.get_mongo_db)):
    return await get_geofence_service(account_id, db)

@router.post("/{account_id}", response_model=Geofence)
async def post_geofence(account_id: str, geofence: GeofenceCreate, db=Depends(database.get_mongo_db)):
    return await create_geofence_service(geofence, db)

@router.put("/{account_id}", response_model=Geofence)
async def update_geofence(account_id: str, update: GeofenceUpdate, db=Depends(database.get_mongo_db)):
    return await update_geofence_service(account_id, update, db)

@router.delete("/{account_id}", response_model=Geofence)
async def delete_geofence(account_id: str, db=Depends(database.get_mongo_db)):
    return await delete_geofence_service(account_id, db)
